# Changelog

All notable changes to the AI Spun Webscraper extension will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [0.0.5] - 2024-01-20

### Changed
- Improved header link visibility with high-contrast bright yellow color (#ffd700)
- Enhanced brand link hover effects with better text shadow
- Updated extension version to 0.0.5

### Fixed
- Header link readability issues against dark gradient background
- Poor contrast between blue links and purple/blue gradient header

### Technical Details
- Updated .brand-link CSS with bright yellow color and text shadow
- Added enhanced hover effects for better user experience
- Improved accessibility with higher contrast ratios

## [0.0.4] - 2024-01-20

### Fixed
- Critical JavaScript syntax error in options.js that prevented extension functionality
- Event listener binding issues that caused menu links and buttons to be non-functional
- Extension loading problems in Chrome development mode

### Changed
- Updated extension version to 0.0.4
- Improved error handling and code stability
- Enhanced debugging and development experience

### Technical Details
- Removed extra closing brace in options.js event binding section
- Synchronized build directory with latest fixes
- Updated version references across all files

## [0.0.3] - 2024-01-20

### Added
- AI APIs configuration page with support for Apify and OpenRouter
- AIAPIManager class for managing API connections and configurations
- API key management with secure storage
- Connection testing functionality for both Apify and OpenRouter
- AI processing options configuration
- Enhanced UI with new AI APIs tab in options page
- API status indicators showing configuration state

### Changed
- Updated extension version to 0.0.3
- Enhanced options page with AI integration capabilities
- Improved extension architecture to support AI services
- Updated manifest.json to include AI APIs resources

### Technical Details
- Added `lib/ai-apis.js` for AI API management
- Enhanced `options.js` with AI configuration methods
- Updated `options.html` with AI APIs tab and controls
- Added CSS styles for AI APIs interface elements

## [0.0.2] - 2024-01-20

### Changed
- Enhanced selector functionality and UI improvements
- Improved data handling and export capabilities
- Bug fixes and performance optimizations

## [0.0.1] - 2024-01-20

### Added🎉 Initial Release

This is the first release of AI Spun Webscraper by Spun Web Technology.

### ✨ Added

#### Core Features
- **Visual Selector Builder**: Point-and-click interface for creating CSS selectors
- **Real-time Data Preview**: Live preview of extracted data as selectors are built
- **Multiple Export Formats**: Support for JSON, CSV, and Excel (XLSX) exports
- **Sitemap Management**: Create and manage multiple scraping configurations
- **Progress Tracking**: Real-time statistics and progress monitoring

#### User Interface
- **Modern Design**: Professional UI with Spun Web Technology branding
- **Responsive Layout**: Optimized for various screen sizes
- **Intuitive Navigation**: Tab-based interface for easy configuration
- **Status Indicators**: Visual feedback for scraping operations

#### Scraping Capabilities
- **Infinite Scroll Support**: Automatic handling of dynamically loaded content
- **Duplicate Detection**: Smart filtering to prevent redundant data collection
- **Error Handling**: Robust error management and recovery
- **Pause/Resume**: Full control over scraping operations
- **Rate Limiting**: Configurable delays to respect server resources

#### Data Management
- **Multiple Data Types**: Support for text, links, images, and custom attributes
- **Bulk Operations**: Process multiple selectors simultaneously
- **Data Validation**: Built-in validation for extracted content
- **Export Options**: Flexible export with custom naming and formatting

#### Safety Features
- **Execution Limits**: Maximum runtime protection to prevent infinite loops
- **Memory Management**: Efficient handling of large datasets
- **Error Recovery**: Automatic retry mechanisms for failed operations
- **Safe Defaults**: Conservative settings to protect both user and target sites

### 🔧 Technical Details

#### Architecture
- **Manifest V3**: Built using the latest Chrome extension standards
- **Service Worker**: Background processing for reliable operation
- **Content Scripts**: Secure injection for page interaction
- **Storage API**: Persistent configuration and data storage

#### Browser Support
- **Chrome**: Version 88+ (Manifest V3 support required)
- **Chromium**: Compatible with Chromium-based browsers
- **Edge**: Microsoft Edge 88+ supported

#### Performance
- **Optimized Selectors**: Efficient CSS selector processing
- **Lazy Loading**: On-demand resource loading for better performance
- **Memory Efficient**: Minimal memory footprint during operation
- **Fast Exports**: Optimized data export processing

### 📋 Known Limitations

- **Single Tab**: Currently supports one active scraping session per tab
- **JavaScript Rendering**: Limited support for heavily JavaScript-dependent sites
- **Authentication**: No built-in support for login-required pages
- **File Downloads**: Cannot scrape content that requires file downloads

### 🔮 Planned Features

#### Version 0.0.2
- **Multi-tab Support**: Concurrent scraping across multiple tabs
- **Scheduler**: Automated scraping at specified intervals
- **Cloud Sync**: Synchronize configurations across devices
- **Advanced Filters**: More sophisticated data filtering options

#### Future Releases
- **API Integration**: RESTful API for programmatic access
- **Machine Learning**: AI-powered selector suggestions
- **Team Collaboration**: Shared configurations and results
- **Enterprise Features**: Advanced security and compliance tools

### 🐛 Bug Fixes

*No bug fixes in initial release*

### 🔄 Changed

*No changes in initial release*

### ⚠️ Deprecated

*No deprecations in initial release*

### 🗑️ Removed

*No removals in initial release*

### 🔒 Security

- **Content Security Policy**: Strict CSP implementation
- **Permission Model**: Minimal required permissions
- **Data Privacy**: No data collection or external transmission
- **Secure Storage**: Encrypted local storage for sensitive data

---

## Version Numbering

This project follows semantic versioning (SemVer):
- **MAJOR.MINOR.PATCH** (e.g., 1.0.0)
- **MAJOR**: Incompatible API changes
- **MINOR**: New functionality in a backwards compatible manner
- **PATCH**: Backwards compatible bug fixes

### Release Schedule

- **Patch releases**: As needed for critical bug fixes
- **Minor releases**: Monthly feature updates
- **Major releases**: Quarterly major feature additions

---

## Support

For questions about specific versions or to report issues:

- **Email**: [support@spunwebtechnology.com](mailto:support@spunwebtechnology.com)
- **Website**: [www.spunwebtechnology.com](https://www.spunwebtechnology.com)

---

*Maintained by Spun Web Technology*  
*Author: Ryan Dickie Thompson*