# Airwave Audio Player Matrix

A WordPress plugin for streaming audio (Shoutcast/Icecast/Sonic Panel), displaying now-playing metadata, and integrating Matrix-based chat.

## Features
- Audio playback for Shoutcast, Icecast, and Sonic Panel streams
- Metadata retrieval and display (title, artist, art, listeners, DJ, history)
- Matrix client integration for chat/rooms
- Shortcodes and widgets for easy embedding
- Admin settings and localized frontend configuration

## Requirements
- WordPress 5.0+
- PHP 7.4+ recommended
- Access to a compatible audio stream with metadata

## Installation
1. Copy the plugin folder to `wp-content/plugins/airwave-audio-player-matrix/`.
2. Activate the plugin in WordPress Admin → Plugins.
3. Configure stream and Matrix settings under the plugin settings page.

## Automatic Updates

This plugin supports automatic updates through the **Spun Plugin Updater** plugin.

### Setting Up Automatic Updates

1. **Install Spun Plugin Updater**
   - Download and activate the "Spun Plugin Updater" plugin from your WordPress dashboard
   - Access settings via: Dashboard sidebar → Plugin Updater, or Tools → Plugin Updater

2. **Configure This Plugin**
   - Navigate to **Plugin Updater → Manage Updates**
   - Click "Add Plugin" and fill in:
     - **Plugin File**: `airwave-audio-player-matrix/airwave-audio-player-matrix.php`
     - **Plugin Slug**: `airwave-audio-player-matrix`
     - **Repository URL**: `https://spunwebtechnology.com/wp-content/uploads/repository/airwave-audio-player-matrix/`
     - **Version Constant**: `AIRWAVE_PLUGIN_VERSION` (optional - will use plugin header if blank)

3. **Receive Updates**
   - Updates will appear in **Plugins → Updates** when available
   - Update notifications appear in your WordPress dashboard
   - One-click updates directly from the Plugins page

### Repository Information

- **Repository Base**: `https://spunwebtechnology.com/wp-content/uploads/repository`
- **Plugin Repository**: `https://spunwebtechnology.com/wp-content/uploads/repository/airwave-audio-player-matrix/`
- **Info JSON**: `https://spunwebtechnology.com/wp-content/uploads/repository/airwave-audio-player-matrix/info.json`
- **Package URL**: `https://spunwebtechnology.com/wp-content/uploads/repository/airwave-audio-player-matrix/airwave-audio-player-matrix-{version}.zip`
- **Download Handler**: `https://spunwebtechnology.com/wp-content/uploads/repository/airwave-audio-player-matrix/download.php`

The repository is checked every 12 hours for new versions. When a new version is detected, you'll see update notifications in your WordPress dashboard.

**Note:** This plugin requires **Spun Plugin Updater v0.2.5 or later** for full automatic update functionality. The Plugin Updater handles update detection, notifications, and installation directly through the WordPress update system.

## Usage
- Embed via shortcode or widget:
  - `[airwave_radio]` - Audio player with metadata display
  - `[airwave_matrix]` - Matrix chat client
  - `[airwave_combined]` - Combined radio and chat interface
- Frontend scripts are localized with `AWMX` object containing:
  - `AWMX.ajax` – `admin-ajax.php` URL
  - `AWMX.nonce` – nonce for AJAX security
  - `AWMX.radio` – stream + metadata endpoint configuration
  - `AWMX.matrix` – homeserver and room settings

## Troubleshooting
- If audio plays but metadata does not display:
  - Check the admin-ajax `airwave_meta` calls include a valid `nonce` and parameters
  - Inspect `includes/meta-proxy.php` mapping for your stream type
  - Review JS selectors and DOM structure expected by `assets/js/awmx-meta.js`
- Ensure your stream server allows cross-origin requests for metadata
- Check browser console for JavaScript errors

## Support & Contact

**Author:** Spun Web Technology

- **Matrix:** [@disruptarianradio:matrix.org](https://matrix.to/#/@disruptarianradio:matrix.org)
- **Support Channel:** [#airwavesupport:matrix.org](https://matrix.to/#/#airwavesupport:matrix.org)
- **Toll Free:** +1 (888) 264‑6790
- **Email:** support@spunwebtechnology.com
- **Website:** [spunwebtechnology.com](https://spunwebtechnology.com)

## License

MIT License - Free and open source software maintained by Spun Web Technology.
