jQuery(document).ready(function($) {
    // Handle main settings form submission
    $('#airwave-settings-form').on('submit', function(e) {
        // Don't prevent default - let WordPress Settings API handle it
        // Just show a loading state and success message after submission
        var $form = $(this);
        var $submitBtn = $form.find('input[type="submit"]');
        var $message = $('#airwave-save-message');
        
        // Show loading state
        $submitBtn.prop('disabled', true).val('Saving...');
        $message.hide().removeClass('success error');
        
        // After form submits, check for success
        setTimeout(function() {
            // Check if settings were saved by looking for WordPress success message
            if ($('.notice-success').length > 0 || window.location.search.indexOf('settings-updated=true') !== -1) {
                $message.addClass('success').text('Settings saved successfully!').fadeIn();
                $submitBtn.prop('disabled', false).val('Save Settings');
                
                // Fade out message after 3 seconds
                setTimeout(function() {
                    $message.fadeOut();
                }, 3000);
            } else {
                $submitBtn.prop('disabled', false).val('Save Settings');
            }
        }, 100);
    });
    
    // Function to update admin bar status indicators
    function updateAdminBarStatus() {
        if (typeof airwaveStatus !== 'undefined') {
            $.ajax({
                url: airwaveStatus.ajax_url,
                type: 'POST',
                data: {
                    action: 'airwave_get_status',
                    nonce: airwaveStatus.nonce
                },
                success: function(response) {
                    if (response.success) {
                        var status = response.data;
                        
                        // Update stream status
                        var $streamIndicator = $('#airwave-stream-indicator');
                        var $streamItem = $('#airwave-stream-status');
                        
                        if (status.stream_online) {
                            $streamIndicator.removeClass('offline').addClass('online');
                            $streamItem.attr('href', status.stream_url);
                            $streamItem.attr('title', 'Stream is online - Click to go to stream page');
                        } else {
                            $streamIndicator.removeClass('online').addClass('offline');
                            $streamItem.attr('href', '#');
                            $streamItem.attr('title', 'Stream is offline');
                        }
                        
                        // Update Matrix status
                        var $matrixIndicator = $('#airwave-matrix-indicator');
                        var $matrixItem = $('#airwave-matrix-status');
                        
                        if (status.matrix_logged_in) {
                            $matrixIndicator.removeClass('offline').addClass('online');
                            $matrixItem.attr('href', status.chat_url);
                            $matrixItem.attr('title', 'Logged in as ' + status.matrix_user + ' - Click to go to chat');
                            $matrixItem.find('.ab-item').html('<span class="airwave-status-indicator online" id="airwave-matrix-indicator"></span> ' + status.matrix_user);
                        } else {
                            $matrixIndicator.removeClass('online').addClass('offline');
                            $matrixItem.attr('href', status.chat_url);
                            $matrixItem.attr('title', 'Not logged in - Click to go to chat login');
                            $matrixItem.find('.ab-item').html('<span class="airwave-status-indicator offline" id="airwave-matrix-indicator"></span> Matrix');
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.log('Status AJAX error:', error);
                }
            });
        } else {
            console.log('airwaveStatus is not defined');
        }
    }
    
    // Display stored test results on page load
    function displayStoredTestResults() {
        // This function can be expanded to show persistent test results
        console.log('Displaying stored test results');
    }
    
    // Test individual stream
    $('.airwave-test-stream').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $button = $(this);
        var streamIndex = $button.data('stream');
        var $result = $('#test-result-' + streamIndex);
        
        $button.prop('disabled', true).text('Saving & Testing...');
        $result.removeClass('success error').text('');
        
        // First save the settings
        var formData = $('form').serialize();
        formData += '&action=airwave_save_settings&nonce=' + airwaveAjax.nonce;
        
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: formData,
            success: function(response) {
                if (response.success) {
                    // Settings saved, now test the stream
                    testStreamConnection(streamIndex, $button, $result);
                } else {
                    $result.addClass('error').text('Failed to save settings');
                    $button.prop('disabled', false).text('Test Stream');
                }
            },
            error: function(xhr, status, error) {
                $result.addClass('error').text('Failed to save settings: ' + error);
                $button.prop('disabled', false).text('Test Stream');
            }
        });
    });
    
    function testStreamConnection(streamIndex, $button, $result) {
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_test_stream',
                nonce: airwaveAjax.nonce,
                stream: streamIndex
            },
            success: function(response) {
                if (response.success) {
                    $result.addClass('success').text(response.data);
                } else {
                    $result.addClass('error').text(response.data);
                }
                updateAdminBarStatus();
            },
            error: function(xhr, status, error) {
                $result.addClass('error').text('Test failed: ' + error);
            },
            complete: function() {
                $button.prop('disabled', false).text('Test Stream');
            }
        });
    }
    
    // Test all streams
    $('.airwave-test-all-streams').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $button = $(this);
        var $result = $('#test-all-result');
        
        $button.prop('disabled', true).text('Testing All Streams...');
        $result.removeClass('success error').text('');
        
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_test_all_streams',
                nonce: airwaveAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.addClass('success').html(response.data);
                } else {
                    $result.addClass('error').text(response.data);
                }
                updateAdminBarStatus();
            },
            error: function(xhr, status, error) {
                $result.addClass('error').text('Test failed: ' + error);
            },
            complete: function() {
                $button.prop('disabled', false).text('Test All Streams');
            }
        });
    });
    
    // Test Matrix connection
    $('.airwave-test-matrix').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        var $button = $(this);
        var $result = $('#test-matrix-result');
        
        $button.prop('disabled', true).text('Testing Matrix...');
        $result.removeClass('success error').text('');
        
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_test_matrix',
                nonce: airwaveAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.addClass('success').text(response.data);
                } else {
                    $result.addClass('error').text(response.data);
                }
                updateAdminBarStatus();
            },
            error: function(xhr, status, error) {
                $result.addClass('error').text('Test failed: ' + error);
            },
            complete: function() {
                $button.prop('disabled', false).text('Test Matrix Connection');
            }
        });
    });
    
    // Homeserver dropdown change handler
    $('#matrix_homeserver').on('change', function() {
        var selectedValue = $(this).val();
        var $customField = $('#custom-homeserver-field');
        
        if (selectedValue === 'custom') {
            $customField.slideDown();
        } else {
            $customField.slideUp();
        }
    });
    
    // Recommended rooms select -> populate Default Room field
    $('#matrix_room_select').on('change', function() {
        var val = $(this).val();
        var $roomInput = $('#matrix_room');
        if (val && val !== 'manual') {
            $roomInput.val(val).trigger('input');
        }
        if (val === 'manual' || !val) {
            // Focus manual input for user entry
            $roomInput.focus();
        }
    });
    
    // Add Stream functionality
    $('#add-stream-btn').on('click', function() {
        var currentCount = parseInt($('#stream-count').text());
        if (currentCount < 5) {
            var nextStream = currentCount + 1;
            $('#stream-section-' + nextStream).slideDown();
            $('#stream-count').text(nextStream);
            
            if (nextStream === 5) {
                $(this).prop('disabled', true).text('Maximum streams reached');
            }
        }
    });
    
    // Remove Stream functionality
    $(document).on('click', '.airwave-remove-stream', function() {
        var streamNum = $(this).data('stream');
        var $section = $('#stream-section-' + streamNum);
        
        // Clear the form fields
        $section.find('input[type="text"], input[type="url"]').val('');
        
        // Hide the section
        $section.slideUp();
        
        // Update count
        var currentCount = parseInt($('#stream-count').text());
        $('#stream-count').text(currentCount - 1);
        
        // Re-enable add button if needed
        if (currentCount === 5) {
            $('#add-stream-btn').prop('disabled', false).text('Add Stream');
        }
    });
    
    // Copy Shortcode functionality
    $(document).on('click', '.airwave-copy-shortcode', function() {
        var shortcode = $(this).data('shortcode');
        copyToClipboard(shortcode);
        $(this).text('Copied!').delay(2000).queue(function() {
            $(this).text('Copy').dequeue();
        });
    });
    
    // Copy button functionality for different button classes
    $(document).on('click', '.airwave-copy-btn', function() {
        var shortcode = $(this).data('shortcode') || $(this).data('text');
        if (shortcode) {
            copyToClipboard(shortcode);
            $(this).text('Copied!').delay(2000).queue(function() {
                $(this).text('Copy').dequeue();
            });
        }
    });
    
    // Copy to clipboard function
    function copyToClipboard(text) {
        if (navigator.clipboard && window.isSecureContext) {
            navigator.clipboard.writeText(text).then(function() {
                console.log('Shortcode copied to clipboard');
            }).catch(function(err) {
                console.error('Failed to copy: ', err);
                fallbackCopyTextToClipboard(text);
            });
        } else {
            fallbackCopyTextToClipboard(text);
        }
    }
    
    // Fallback copy function for older browsers
    function fallbackCopyTextToClipboard(text) {
        var textArea = document.createElement("textarea");
        textArea.value = text;
        textArea.style.top = "0";
        textArea.style.left = "0";
        textArea.style.position = "fixed";
        document.body.appendChild(textArea);
        textArea.focus();
        textArea.select();
        
        try {
            var successful = document.execCommand('copy');
            if (successful) {
                console.log('Fallback: Shortcode copied to clipboard');
            } else {
                console.error('Fallback: Copy command was unsuccessful');
            }
        } catch (err) {
            console.error('Fallback: Unable to copy', err);
        }
        
        document.body.removeChild(textArea);
    }
    
    // Initialize stream count on page load
    function initializeStreamCount() {
        var visibleStreams = 0;
        for (var i = 1; i <= 5; i++) {
            if ($('#stream-section-' + i).is(':visible')) {
                visibleStreams++;
            }
        }
        $('#stream-count').text(visibleStreams);
        
        if (visibleStreams === 5) {
            $('#add-stream-btn').prop('disabled', true).text('Maximum streams reached');
        }
    }
    
    // Matrix Admin Login functionality
    $('#matrix-admin-login-btn').on('click', function() {
        var $button = $(this);
        var $result = $('#matrix-login-result');
        var username = $('#matrix_admin_username').val();
        var password = $('#matrix_admin_password').val();
        
        if (!username || !password) {
            $result.addClass('error').text('Please enter both username and password');
            return;
        }
        
        $button.prop('disabled', true).text('Logging in...');
        $result.removeClass('success error').text('');
        
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_matrix_admin_login',
                username: username,
                password: password,
                nonce: airwaveAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.addClass('success').text('Login successful!');
                    $('#matrix-login-status').show();
                    $('#matrix-login-status-text').text('Connected').removeClass('offline').addClass('online');
                    $('#matrix-login-user').text(response.data.user_id);
                    $('#matrix-login-homeserver').text(response.data.homeserver);
                    $('#matrix-admin-login-btn').hide();
                    $('#matrix-admin-logout-btn').show();
                    $('#matrix_admin_password').val(''); // Clear password field
                    
                    // Update live status
                    updateLiveStatus(true, response.data.user_id);
                    updateAdminBarStatus();
                } else {
                    $result.addClass('error').text(response.data);
                }
            },
            error: function(xhr, status, error) {
                $result.addClass('error').text('Login failed: ' + error);
            },
            complete: function() {
                $button.prop('disabled', false).text('Login to Matrix');
            }
        });
    });
    
    // Matrix Admin Logout functionality
    $('#matrix-admin-logout-btn').on('click', function() {
        var $button = $(this);
        var $result = $('#matrix-login-result');
        
        $button.prop('disabled', true).text('Logging out...');
        
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_matrix_admin_logout',
                nonce: airwaveAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.addClass('success').text('Logged out successfully');
                    $('#matrix-login-status').hide();
                    $('#matrix-admin-login-btn').show();
                    $('#matrix-admin-logout-btn').hide();
                    $('#matrix_admin_password').val('');
                    
                    // Update live status
                    updateLiveStatus(false, 'Logged out');
                    updateAdminBarStatus();
                } else {
                    $result.addClass('error').text(response.data);
                }
            },
            error: function(xhr, status, error) {
                $result.addClass('error').text('Logout failed: ' + error);
            },
            complete: function() {
                $button.prop('disabled', false).text('Logout');
            }
        });
    });
    
    // Check Matrix login status on page load
    function checkMatrixLoginStatus() {
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_matrix_admin_status',
                nonce: airwaveAjax.nonce
            },
            success: function(response) {
                if (response.success && response.data.logged_in) {
                    $('#matrix-login-status').show();
                    $('#matrix-login-status-text').text('Connected').removeClass('offline').addClass('online');
                    $('#matrix-login-user').text(response.data.user_id);
                    $('#matrix-login-homeserver').text(response.data.homeserver);
                    $('#matrix-admin-login-btn').hide();
                    $('#matrix-admin-logout-btn').show();
                    
                    // Show live status as connected
                    updateLiveStatus(true, response.data.user_id);
                } else {
                    $('#matrix-login-status').show();
                    $('#matrix-login-status-text').text('Disconnected').removeClass('online').addClass('offline');
                    $('#matrix-admin-login-btn').show();
                    $('#matrix-admin-logout-btn').hide();
                    
                    // Show live status as disconnected
                    updateLiveStatus(false, 'Not logged in');
                }
            },
            error: function() {
                $('#matrix-login-status').show();
                $('#matrix-login-status-text').text('Connection Error').removeClass('online').addClass('offline');
                
                // Show live status as error
                updateLiveStatus(false, 'Connection Error');
            }
        });
    }
    
    // Update live status indicator
    function updateLiveStatus(isConnected, statusText) {
        $('#matrix-live-status').show();
        
        var $indicator = $('#matrix-live-status-indicator');
        var $text = $('#matrix-live-status-text');
        var $time = $('#matrix-live-status-time');
        
        if (isConnected) {
            $indicator.removeClass('offline').addClass('online');
            $text.text('Connected as ' + statusText).removeClass('offline').addClass('online');
        } else {
            $indicator.removeClass('online').addClass('offline');
            $text.text(statusText).removeClass('online').addClass('offline');
        }
        
        // Update timestamp
        var now = new Date();
        $time.text('Last checked: ' + now.toLocaleTimeString());
    }
    
    // Initialize on page load
    displayStoredTestResults();
    initializeStreamCount();
    
    // Show Matrix status immediately and check connection
    $('#matrix-login-status').show();
    checkMatrixLoginStatus();
    
    // Update admin bar status on page load
    setTimeout(updateAdminBarStatus, 1000);
    
    // Set up periodic Matrix connection check every 30 seconds
    setInterval(function() {
        checkMatrixLoginStatus();
        updateAdminBarStatus();
    }, 30000);
    
    // Debug System JavaScript
    var debugLog = [];
    var testStats = {
        total: 0,
        successful: 0,
        failed: 0,
        lastTestTime: 'Never'
    };
    
    // Test System Health
    $('.airwave-test-system').on('click', function() {
        var testType = $('#test-type').val();
        var debugLevel = $('#debug-level').val();
        
        $(this).prop('disabled', true).text('Testing...');
        
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_test_system',
                test_type: testType,
                debug_level: debugLevel,
                nonce: airwaveAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('#test-system-result').text('System Health: ' + response.data.overall_health + '%').removeClass('error').addClass('success');
                    updateDebugLog(response.data.debug_log);
                    updateTestStats(true);
                } else {
                    $('#test-system-result').text('System test failed: ' + response.data).removeClass('success').addClass('error');
                    updateTestStats(false);
                }
            },
            error: function() {
                $('#test-system-result').text('System test request failed').removeClass('success').addClass('error');
                updateTestStats(false);
            },
            complete: function() {
                $('.airwave-test-system').prop('disabled', false).text('Test System Health');
            }
        });
    });
    
    // Clear Debug Log
    $('.airwave-clear-log').on('click', function() {
        if (confirm('Are you sure you want to clear the debug log?')) {
            $.ajax({
                url: airwaveAjax.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'airwave_clear_debug_log',
                    nonce: airwaveAjax.nonce
                },
                success: function(response) {
                    if (response.success) {
                        $('#debug-log').text('Debug log cleared.');
                        debugLog = [];
                    }
                }
            });
        }
    });
    
    // Download Debug Log
    $('.airwave-download-log').on('click', function() {
        window.open(airwaveAjax.ajaxUrl + '?action=airwave_download_debug_log&nonce=' + airwaveAjax.nonce);
    });
    
    // Refresh Debug Log
    $('.airwave-refresh-log').on('click', function() {
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: {
                action: 'airwave_get_debug_log',
                nonce: airwaveAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    updateDebugLog(response.data.log);
                }
            }
        });
    });
    
    function updateDebugLog(logContent) {
        $('#debug-log').text(logContent);
        $('#debug-log').scrollTop($('#debug-log')[0].scrollHeight);
    }
    
    function updateTestStats(success) {
        testStats.total++;
        if (success) {
            testStats.successful++;
        } else {
            testStats.failed++;
        }
        testStats.lastTestTime = new Date().toLocaleString();
        
        $('#total-tests').text(testStats.total);
        $('#successful-tests').text(testStats.successful);
        $('#failed-tests').text(testStats.failed);
        $('#last-test-time').text(testStats.lastTestTime);
    }
});

jQuery(function($){
    // Test Sonic Panel Connection
    $('.airwave-test-sonic').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();

        var $button = $(this);
        var $result = $('#test-sonic-result');

        $button.prop('disabled', true).text('Saving & Testing...');
        $result.removeClass('success error').text('');

        // First save the settings
        var formData = $('form').serialize();
        formData += '&action=airwave_save_settings&nonce=' + airwaveAjax.nonce;

        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: formData,
            success: function(saveResponse) {
                if (saveResponse.success) {
                    // Now test Sonic panel connection
                    $.ajax({
                        url: airwaveAjax.ajaxUrl,
                        type: 'POST',
                        data: {
                            action: 'airwave_test_sonic',
                            nonce: airwaveAjax.nonce
                        },
                        success: function(testResponse) {
                            if (testResponse.success) {
                                $result.addClass('success').text(testResponse.data);
                            } else {
                                $result.addClass('error').text(testResponse.data);
                            }
                            updateAdminBarStatus();
                        },
                        error: function(xhr, status, error) {
                            $result.addClass('error').text('Test failed: ' + error);
                        },
                        complete: function() {
                            $button.prop('disabled', false).text('Test Sonic Panel Connection');
                        }
                    });
                } else {
                    $result.addClass('error').text('Failed to save settings');
                    $button.prop('disabled', false).text('Test Sonic Panel Connection');
                }
            },
            error: function(xhr, status, error) {
                $result.addClass('error').text('Failed to save settings: ' + error);
                $button.prop('disabled', false).text('Test Sonic Panel Connection');
            }
        });
    });
    $('#display_theme').on('change', function(){
        var formData = $('form').serialize();
        formData += '&action=airwave_save_settings&nonce=' + airwaveAjax.nonce;
        var selected = $('#display_theme').val();
        $.ajax({
            url: airwaveAjax.ajaxUrl,
            type: 'POST',
            data: formData,
            success: function(response){
                if (response && response.success) {
                    // Update local settings and apply theme immediately
                    airwaveAjax.settings = airwaveAjax.settings || {};
                    airwaveAjax.settings.display_theme = selected;
                    if (window.AirwaveFrontend) {
                        AirwaveFrontend.settings.display_theme = selected;
                        AirwaveFrontend.applyTheme();
                    } else {
                        // Fallback: toggle preview classes manually
                        var resolved = selected;
                        var $preview = $('#airwave-theme-preview');
                        $preview.toggleClass('airwave-theme-light', resolved === 'light');
                        $preview.toggleClass('airwave-theme-neutral', resolved === 'neutral');
                        $preview.find('.awmx-card').each(function(){
                            $(this).toggleClass('awmx-theme-light', resolved === 'light');
                            $(this).toggleClass('awmx-theme-dark', resolved === 'dark');
                            $(this).toggleClass('awmx-theme-neutral', resolved === 'neutral');
                        });
                    }
                }
            }
        });
    });
    
    // Default Cover Image Upload Handler
    var mediaUploader;
    
    $('#upload_default_cover_btn').on('click', function(e) {
        e.preventDefault();
        
        // If uploader already exists, open it
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }
        
        // Create new media uploader
        mediaUploader = wp.media({
            title: 'Choose Default Cover Image',
            button: {
                text: 'Use this image'
            },
            multiple: false,
            library: {
                type: 'image'
            }
        });
        
        // When image is selected
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#default_cover_image').val(attachment.id);
            $('#default_cover_preview').attr('src', attachment.url).show();
            $('#upload_default_cover_btn').text('Change Image');
            
            // Show remove button
            if ($('#remove_default_cover_btn').length === 0) {
                $('#upload_default_cover_btn').after('<button type="button" class="button" id="remove_default_cover_btn">Remove Image</button>');
            }
        });
        
        // Open media uploader
        mediaUploader.open();
    });
    
    // Remove Default Cover Image
    $(document).on('click', '#remove_default_cover_btn', function(e) {
        e.preventDefault();
        $('#default_cover_image').val('');
        $('#default_cover_preview').attr('src', '').hide();
        $('#upload_default_cover_btn').text('Upload Image');
        $('#remove_default_cover_btn').remove();
    });
});