jQuery(document).ready(function($) {
    function updateStatus() {
        if (typeof airwaveStatus !== 'undefined') {
            $.ajax({
                url: airwaveStatus.ajax_url,
                type: 'POST',
                data: {
                    action: 'airwave_get_status',
                    nonce: airwaveStatus.nonce
                },
                success: function(response) {
                    if (response.success) {
                        var status = response.data;
                        
                        // Update stream status
                        var $streamIndicator = $('#airwave-stream-indicator');
                        var $streamItem = $('#airwave-stream-status');
                        
                        if (status.stream_online) {
                            $streamIndicator.removeClass('offline').addClass('online');
                            $streamItem.attr('href', status.stream_url);
                            $streamItem.attr('title', 'Stream is online - Click to go to stream page');
                        } else {
                            $streamIndicator.removeClass('online').addClass('offline');
                            $streamItem.attr('href', '#');
                            $streamItem.attr('title', 'Stream is offline');
                        }
                        
                        // Update Matrix status
                        var $matrixIndicator = $('#airwave-matrix-indicator');
                        var $matrixItem = $('#airwave-matrix-status');
                        
                        if (status.matrix_logged_in) {
                            $matrixIndicator.removeClass('offline').addClass('online');
                            $matrixItem.attr('href', status.chat_url);
                            $matrixItem.attr('title', 'Logged in as ' + status.matrix_user + ' - Click to go to chat');
                            $matrixItem.find('.ab-item').html('<span class="airwave-status-indicator online" id="airwave-matrix-indicator"></span> ' + status.matrix_user);
                        } else {
                            $matrixIndicator.removeClass('online').addClass('offline');
                            $matrixItem.attr('href', status.chat_url);
                            $matrixItem.attr('title', 'Not logged in - Click to go to chat login');
                            $matrixItem.find('.ab-item').html('<span class="airwave-status-indicator offline" id="airwave-matrix-indicator"></span> Matrix');
                        }
                    }
                },
                error: function(xhr, status, error) {
                    console.log('Status update error:', error);
                }
            });
        }
    }
    
    // Update status every 30 seconds
    setInterval(updateStatus, 30000);
    
    // Initial update
    updateStatus();
});