<?php
/**
 * Frontend functionality for Airwave Audio Player Matrix
 */

if (!defined('ABSPATH')) {
    exit;
}

class AirwaveFrontend {
    
    public function __construct() {
        add_action('wp_enqueue_scripts', array($this, 'enqueue_frontend_scripts'));
        // Removed footer init script to avoid legacy AirwaveFrontend init collisions
    }
    
    public function enqueue_frontend_scripts() {
        // Only load styles if our widgets/shortcodes are present
        if ( $this->has_airwave_content() ) {
            // Base frontend styles
            wp_enqueue_style(
                'airwave-frontend-css',
                set_url_scheme(AIRWAVE_PLUGIN_URL . 'assets/css/frontend.css'),
                array(),
                AIRWAVE_PLUGIN_VERSION
            );
        }
        // Do NOT enqueue legacy frontend.js. JS is handled by main plugin (awmx-audio/meta/matrix)
        // Do NOT localize legacy airwaveAjax here to avoid duplicate controllers
    }
    
    private function has_airwave_content() {
        global $post;
        
        if (!$post) {
            return false;
        }
        
        // Check if any Airwave shortcodes are present
        $shortcodes = array('airwave_radio', 'airwave_matrix', 'airwave_combined', 'airwave_song_history', 'airwave_chat_room', 'matrix_chat', 'airwave_now_playing', 'airwave_current_song');
        
        foreach ($shortcodes as $shortcode) {
            if (has_shortcode($post->post_content, $shortcode)) {
                return true;
            }
        }
        
        // Check if any Airwave widgets are active
        $widgets = array('airwave_radio_widget', 'airwave_matrix_widget', 'airwave_combined_widget', 'airwave_song_history_widget');
        
        foreach ($widgets as $widget) {
            if (is_active_widget(false, false, $widget)) {
                return true;
            }
        }
        
        return false;
    }
    
    private function has_matrix_content() {
        global $post;
        
        if (!$post) {
            return false;
        }
        
        // Check if Matrix shortcodes are present
        $matrix_shortcodes = array('airwave_matrix', 'airwave_combined', 'airwave_chat_room', 'matrix_chat');
        
        foreach ($matrix_shortcodes as $shortcode) {
            if (has_shortcode($post->post_content, $shortcode)) {
                return true;
            }
        }
        
        return false;
    }
}
