<?php
/**
 * Shortcodes for Airwave Audio Player Matrix
 */

if (!defined('ABSPATH')) {
    exit;
}

class AirwaveShortcodes {
    
    public function __construct() {
        // Removed legacy 'airwave_radio' shortcode registration to prevent overriding AWMX radio shortcode
        add_shortcode('airwave_matrix', array($this, 'matrix_shortcode'));
        add_shortcode('airwave_combined', array($this, 'combined_shortcode'));
        add_shortcode('airwave_song_history', array($this, 'song_history_shortcode'));
        add_shortcode('airwave_visualizer', array($this, 'visualizer_shortcode'));
        add_shortcode('airwave_current_song', array($this, 'current_song_shortcode'));
        add_shortcode('airwave_news_ticker', array($this, 'news_ticker_shortcode'));
        add_shortcode('airwave_song_history_list', array($this, 'song_history_list_shortcode'));
        add_shortcode('airwave_chat_room', array($this, 'chat_room_shortcode'));
        add_shortcode('airwave_song_ticker', array($this, 'song_ticker_shortcode'));
        add_shortcode('airwave_front_row', array($this, 'front_row_shortcode'));
        add_shortcode('airwave_now_playing', array($this, 'now_playing_shortcode'));
    }
    
    public function radio_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'show_history' => 'false',
            'show_visualizer' => 'true',
            'title' => '',
            'theme' => ''
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $show_history = $atts['show_history'] === 'true';
        $show_visualizer = $atts['show_visualizer'] === 'true';
        $title = sanitize_text_field($atts['title']);
        
        // Determine theme: shortcode attribute wins; otherwise fallback to admin setting
        $settings = get_option('airwave_settings', array());
        $theme_attr = isset($atts['theme']) ? sanitize_text_field($atts['theme']) : '';
        $theme = $theme_attr !== '' ? $theme_attr : ($settings['display_theme'] ?? 'dark');
        if ($theme === 'system') { $theme = 'dark'; }
        // Support alias names for neutral modern
        if ($theme === 'neutral-modern' || $theme === 'modern-neutral') { $theme = 'neutral'; }
        // Validate theme
        if (!in_array($theme, array('dark','light','neutral'))) { $theme = 'dark'; }
        $theme_class = 'awmx-theme-' . ($theme === 'neutral' ? 'neutral' : ($theme === 'light' ? 'light' : 'dark'));
        
        ob_start();
        ?>
        <?php /* theme_class set above using shortcode fallback */ ?>
        <div class="airwave-radio-shortcode awmx-card <?php echo esc_attr($theme_class); ?>" data-stream="<?php echo esc_attr($stream_index); ?>" data-show-history="<?php echo $show_history ? 'true' : 'false'; ?>" data-show-visualizer="<?php echo $show_visualizer ? 'true' : 'false'; ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-player-controls">
                <div class="airwave-stream-select">
                    <select class="airwave-stream-dropdown">
                        <option value="">Select Stream...</option>
                    </select>
                </div>
                
                <div class="airwave-control-buttons">
                    <button class="airwave-play-btn">Play</button>
                    <button class="airwave-stop-btn" disabled>Stop</button>
                </div>
                
                <div class="airwave-volume-control">
                    <label>Volume</label>
                    <input type="range" class="airwave-volume-slider" min="0" max="1" step="0.05" value="0.8" />
                </div>
            </div>
            
            <?php if ($show_visualizer): ?>
            <div class="airwave-visualizer">
                <canvas class="airwave-viz-canvas" width="400" height="120"></canvas>
            </div>
            <?php endif; ?>
            <div id="radio" class="airwave-tab-panel active">
                <?php echo do_shortcode('[airwave_radio]'); ?>
            </div>
        </div>
            
            <?php if ($show_history): ?>
            <div class="airwave-song-history">
                <h4>Recent Songs</h4>
                <div class="airwave-history-list"></div>
            </div>
            <?php endif; ?>
            
            <audio class="airwave-audio-player" preload="none"></audio>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function matrix_shortcode($atts) {
        $atts = shortcode_atts(array(
            'room' => '',
            'show_room_selector' => 'true',
            'title' => '',
            'logged_in' => 'false'
        ), $atts);
        
        // Start with shortcode-provided room
        $room_id = sanitize_text_field($atts['room']);
        
        // If no room provided, fall back to Admin default from settings
        if (empty($room_id)) {
            $settings = get_option('airwave_settings', array());
            if (!empty($settings['matrix_room'])) {
                $room_id = sanitize_text_field($settings['matrix_room']);
            }
        }
        
        $show_room_selector = $atts['show_room_selector'] === 'true';
        $title = sanitize_text_field($atts['title']);
        $logged_in = $atts['logged_in'] === 'true';
        
        ob_start();
        ?>
        <?php $settings = get_option('airwave_settings', array()); $theme = $settings['display_theme'] ?? 'dark'; if ($theme === 'system') { $theme = 'dark'; } $theme_class = 'awmx-theme-' . ($theme === 'neutral' ? 'neutral' : ($theme === 'light' ? 'light' : 'dark')); ?>
        <div class="airwave-matrix-shortcode awmx-card <?php echo esc_attr($theme_class); ?>" data-room="<?php echo esc_attr($room_id); ?>" data-show-selector="<?php echo $show_room_selector ? 'true' : 'false'; ?>" data-logged-in="<?php echo $logged_in ? 'true' : 'false'; ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <?php if ($logged_in): ?>
            <div class="airwave-matrix-status">
                <div class="airwave-login-status">
                    <span class="airwave-status-indicator airwave-status-connected"></span>
                    <span class="airwave-status-text">Connected as @disruptarianradio:matrix.org</span>
                </div>
            </div>
            
            <?php if ($show_room_selector): ?>
            <div class="airwave-room-selector">
                <h4>Rooms</h4>
                <div class="airwave-room-list"></div>
                <div class="airwave-join-room">
                    <select class="airwave-room-select">
                        <option value="">Select a room…</option>
                        <option value="#airwavesupport:matrix.org">#airwavesupport:matrix.org — Plugin Support From AirwaveAutomator</option>
                        <option value="#disruptiverequests:matrix.org">#disruptiverequests:matrix.org — Radio Chatbot Demonstration</option>
                        <option value="#matrix:matrix.org">#matrix:matrix.org — Official Matrix room</option>
                        <option value="#general:matrix.org">#general:matrix.org — General discussion</option>
                        <option value="#help:matrix.org">#help:matrix.org — Help and support</option>
                        <option value="manual">Enter manually…</option>
                    </select>
                    <input type="text" class="airwave-room-input" placeholder="Enter room ID (e.g., #general:matrix.org)" value="<?php echo esc_attr($room_id); ?>" />
                    <button class="airwave-join-btn">Join Room</button>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="airwave-chat-container">
                <div class="airwave-current-room">
                    <span class="airwave-room-name"><?php echo esc_html($room_id ?: 'No room selected'); ?></span>
                </div>
                
                <div class="airwave-messages-container">
                    <div class="airwave-messages-list"></div>
                </div>
                
                <div class="airwave-message-input">
                    <input type="text" class="airwave-message-field" placeholder="Type your message..." />
                    <button class="airwave-send-btn">Send</button>
                </div>
            </div>
            <?php else: ?>
            <!-- Login Form -->
            <div class="airwave-matrix-login">
                <h4>Login to Matrix Chat</h4>
                <div class="airwave-login-form">
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-homeserver">Homeserver:</label>
                        <select id="airwave-matrix-homeserver" class="airwave-homeserver-select">
                            <option value="https://matrix-client.matrix.org">matrix.org</option>
                            <option value="https://matrix.element.io">Element (matrix.org)</option>
                            <option value="custom">Custom Homeserver</option>
                        </select>
                        <input type="text" id="airwave-custom-homeserver" class="airwave-custom-homeserver" placeholder="https://your-homeserver.com" style="display: none;" />
                    </div>
                    
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-username">Username:</label>
                        <input type="text" id="airwave-matrix-username" class="airwave-username-input" placeholder="@username:domain.com" />
                    </div>
                    
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-password">Password:</label>
                        <input type="password" id="airwave-matrix-password" class="airwave-password-input" placeholder="Your Matrix password" />
                    </div>
                    
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-display-name">Display Name (optional):</label>
                        <input type="text" id="airwave-matrix-display-name" class="airwave-display-name-input" placeholder="Your display name" />
                    </div>
                    
                    <div class="airwave-login-actions">
                        <button class="airwave-login-btn">Login to Chat</button>
                        <button class="airwave-logout-btn" style="display: none;">Logout</button>
                    </div>
                    
                    <div class="airwave-login-status" id="airwave-login-status"></div>
                </div>
                
                <div class="airwave-login-help">
                    <p><strong>Need a Matrix account?</strong></p>
                    <p>You can create a free account at <a href="https://app.element.io" target="_blank">Element</a> or <a href="https://matrix.org" target="_blank">matrix.org</a></p>
                    <p><strong>Popular rooms to join:</strong></p>
                    <ul>
                        <li><code>#general:matrix.org</code> - General discussion</li>
                        <li><code>#help:matrix.org</code> - Help and support</li>
                        <li><code>#airwavesupport:matrix.org</code> - Airwave support</li>
                    </ul>
                    <div class="airwave-join-room">
                        <input type="text" class="airwave-room-input" placeholder="Enter room ID (e.g., #general:matrix.org)" value="<?php echo esc_attr($room_id); ?>" />
                        <button class="airwave-join-btn">Join Room</button>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php
        return ob_get_clean();
    }

    public function combined_shortcode($atts) {
        $atts = shortcode_atts(array(
            'title' => '',
            'logged_in' => 'false',
            'stream' => '0',
            'room' => '#general:matrix.org'
        ), $atts);
        
        $title = sanitize_text_field($atts['title']);
        $logged_in = $atts['logged_in'] === 'true';
        $stream_index = intval($atts['stream']);
        $room = sanitize_text_field($atts['room']);
        
        ob_start();
        ?>
        <?php $settings = get_option('airwave_settings', array()); $theme = $settings['display_theme'] ?? 'dark'; if ($theme === 'system') { $theme = 'dark'; } $theme_class = 'awmx-theme-' . ($theme === 'neutral' ? 'neutral' : ($theme === 'light' ? 'light' : 'dark')); ?>
        <div class="airwave-combined-shortcode" data-stream="<?php echo esc_attr($stream_index); ?>" data-room="<?php echo esc_attr($room); ?>" data-logged-in="<?php echo $logged_in ? 'true' : 'false'; ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-tabs">
                <nav class="airwave-tab-nav">
                    <button type="button" class="airwave-tab-btn active" data-tab="radio">Radio</button>
                    <button type="button" class="airwave-tab-btn" data-tab="chat">Chat</button>
                </nav>
                
                <div class="airwave-tab-content">
                    <div id="radio" class="airwave-tab-panel active">
                        <?php echo do_shortcode('[airwave_radio]'); ?>
                    </div>
                    
                    <div id="chat" class="airwave-tab-panel">
                        <?php echo do_shortcode('[matrix_chat]'); ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    public function song_history_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'limit' => '10',
            'title' => ''
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $history_limit = intval($atts['limit']);
        $title = sanitize_text_field($atts['title']);
        
        ob_start();
        ?>
        <div class="airwave-song-history-shortcode" data-stream="<?php echo esc_attr($stream_index); ?>" data-limit="<?php echo esc_attr($history_limit); ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-current-song">
                <h4>Now Playing</h4>
                <div class="airwave-song-info">
                    <div class="airwave-song-title">-</div>
                    <div class="airwave-song-artist">-</div>
                </div>
                <div class="airwave-song-art">
                    <img class="airwave-album-art" src="" alt="" style="display: none;" />
                </div>
            </div>
            
            <div class="airwave-song-history">
                <h4>Recent Songs</h4>
                <div class="airwave-history-list"></div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function visualizer_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'width' => '400',
            'height' => '200',
            'type' => 'bars',
            'title' => ''
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $width = intval($atts['width']) ?: 400;
        $height = intval($atts['height']) ?: 200;
        $type = sanitize_text_field($atts['type']);
        $title = sanitize_text_field($atts['title']);
        
        ob_start();
        ?>
        <div class="airwave-visualizer-shortcode" data-stream="<?php echo esc_attr($stream_index); ?>" data-type="<?php echo esc_attr($type); ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-visualizer">
                <canvas class="airwave-viz-canvas" width="<?php echo esc_attr($width); ?>" height="<?php echo esc_attr($height); ?>" style="width:100%;max-width:<?php echo esc_attr($width); ?>px;height:<?php echo esc_attr($height); ?>px;display:block;"></canvas>
            </div>
            
            <audio class="airwave-audio-player" preload="none" crossorigin="anonymous"></audio>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function current_song_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'show_cover' => 'true',
            'title' => ''
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $show_cover = $atts['show_cover'] === 'true';
        $title = sanitize_text_field($atts['title']);
        
        ob_start();
        ?>
        <?php $settings = get_option('airwave_settings', array()); $theme = $settings['display_theme'] ?? 'dark'; if ($theme === 'system') { $theme = 'dark'; } $theme_class = 'awmx-theme-' . ($theme === 'neutral' ? 'neutral' : ($theme === 'light' ? 'light' : 'dark')); ?>
        <div class="airwave-current-song-shortcode awmx-card <?php echo esc_attr($theme_class); ?>" data-stream="<?php echo esc_attr($stream_index); ?>" data-show-cover="<?php echo $show_cover ? 'true' : 'false'; ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-current-song">
                <div class="airwave-song-info">
                    <div class="airwave-song-title">-</div>
                    <div class="airwave-song-artist">-</div>
                </div>
                <?php if ($show_cover): ?>
                <div class="airwave-song-art">
                    <img class="airwave-album-art" src="" alt="" style="display: none;" />
                </div>
                <?php endif; ?>
            </div>
            
            <audio class="airwave-audio-player" preload="none"></audio>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function news_ticker_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'speed' => 'medium',
            'title' => ''
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $speed = sanitize_text_field($atts['speed']);
        $title = sanitize_text_field($atts['title']);
        
        ob_start();
        ?>
        <div class="airwave-news-ticker-shortcode" data-stream="<?php echo esc_attr($stream_index); ?>" data-speed="<?php echo esc_attr($speed); ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-news-ticker">
                <div class="airwave-ticker-container">
                    <div class="airwave-ticker-content">
                        <div class="airwave-ticker-left">
                            <span class="airwave-current-song-ticker">Now Playing: -</span>
                        </div>
                        <div class="airwave-ticker-right">
                            <span class="airwave-song-history-ticker">Recent: -</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <audio class="airwave-audio-player" preload="none"></audio>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function song_history_list_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'limit' => '10',
            'title' => ''
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $history_limit = intval($atts['limit']);
        $title = sanitize_text_field($atts['title']);
        
        ob_start();
        ?>
        <div class="airwave-song-history-list-shortcode" data-stream="<?php echo esc_attr($stream_index); ?>" data-limit="<?php echo esc_attr($history_limit); ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-song-history-list">
                <h4>Recently Played Songs</h4>
                <ul class="airwave-history-list-vertical">
                    <li class="airwave-history-item">No songs played yet</li>
                </ul>
            </div>
            
            <audio class="airwave-audio-player" preload="none"></audio>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function chat_room_shortcode($atts) {
        $atts = shortcode_atts(array(
            'room' => '#airwavesupport:matrix.org',
            'title' => 'Community Chat',
            'show_login' => 'true',
            'max_height' => '400'
        ), $atts);
        
        $room = sanitize_text_field($atts['room']);
        $title = sanitize_text_field($atts['title']);
        $show_login = $atts['show_login'] === 'true';
        $max_height = intval($atts['max_height']);
        
        ob_start();
        ?>
        <div class="airwave-chat-room-shortcode" data-room="<?php echo esc_attr($room); ?>" data-max-height="<?php echo esc_attr($max_height); ?>" data-logged-in="false">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <?php if ($show_login): ?>
            <div class="airwave-matrix-login">
                <h4>Login to Matrix Chat</h4>
                <div class="airwave-login-form">
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-homeserver-chatroom">Homeserver:</label>
                        <select id="airwave-matrix-homeserver-chatroom" class="airwave-homeserver-select">
                            <option value="https://matrix-client.matrix.org">matrix.org</option>
                            <option value="https://matrix.element.io">Element (matrix.org)</option>
                            <option value="custom">Custom Homeserver</option>
                        </select>
                        <input type="text" id="airwave-custom-homeserver-chatroom" class="airwave-custom-homeserver" placeholder="https://your-homeserver.com" style="display: none;" />
                    </div>
                    
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-username-chatroom">Username:</label>
                        <input type="text" id="airwave-matrix-username-chatroom" class="airwave-username-input" placeholder="@username:domain.com" />
                    </div>
                    
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-password-chatroom">Password:</label>
                        <input type="password" id="airwave-matrix-password-chatroom" class="airwave-password-input" placeholder="Your Matrix password" />
                    </div>
                    
                    <div class="airwave-login-field">
                        <label for="airwave-matrix-display-name-chatroom">Display Name (optional):</label>
                        <input type="text" id="airwave-matrix-display-name-chatroom" class="airwave-display-name-input" placeholder="Your display name" />
                    </div>
                    
                    <div class="airwave-login-actions">
                        <button class="airwave-login-btn">Login to Chat</button>
                        <button class="airwave-logout-btn" style="display: none;">Logout</button>
                    </div>
                    
                    <div class="airwave-login-status"></div>
                </div>
                
                <div class="airwave-login-help">
                    <p><strong>Need a Matrix account?</strong></p>
                    <p>You can create a free account at <a href="https://app.element.io" target="_blank">Element</a> or <a href="https://matrix.org" target="_blank">matrix.org</a></p>
                    <p><strong>Popular rooms to join:</strong></p>
                    <ul>
                        <li><code>#general:matrix.org</code> - General discussion</li>
                        <li><code>#help:matrix.org</code> - Help and support</li>
                        <li><code>#airwavesupport:matrix.org</code> - Airwave support</li>
                    </ul>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="airwave-matrix-status" style="display: none;"></div>
            
            <div class="airwave-room-selector" style="display: none;">
                <h4>Rooms</h4>
                <div class="airwave-room-list"></div>
                <div class="airwave-join-room">
                    <input type="text" class="airwave-room-input" placeholder="Enter room ID (e.g., #general:matrix.org)" value="<?php echo esc_attr($room); ?>" />
                    <button class="airwave-join-btn">Join Room</button>
                </div>
            </div>
            
            <div class="airwave-chat-container" style="display: none;">
                <div class="airwave-current-room">
                    <span class="airwave-room-name"><?php echo esc_html($room ?: 'No room selected'); ?></span>
                </div>
                
                <div class="airwave-messages-container" style="max-height: <?php echo esc_attr($max_height); ?>px;">
                    <div class="airwave-messages-list"></div>
                </div>
                
                <div class="airwave-message-input">
                    <input type="text" class="airwave-message-field" placeholder="Type your message..." />
                    <button class="airwave-send-btn">Send</button>
                </div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
    
    public function song_ticker_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'limit' => '10',
            'scroll_speed' => '3',
            'title' => 'Now Playing'
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $limit = intval($atts['limit']);
        $scroll_speed = intval($atts['scroll_speed']);
        $title = sanitize_text_field($atts['title']);
        
        ob_start();
        ?>
        <div class="airwave-song-ticker-shortcode" data-stream="<?php echo esc_attr($stream_index); ?>" data-limit="<?php echo esc_attr($limit); ?>" data-scroll-speed="<?php echo esc_attr($scroll_speed); ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-ticker-container">
                <div class="airwave-ticker-content">
                    <div class="airwave-current-song">
                        <img class="airwave-album-art" src="" alt="Album Art" style="display: none;">
                        <div class="airwave-song-info">
                            <div class="airwave-song-title">No song playing</div>
                            <div class="airwave-song-artist"></div>
                        </div>
                    </div>
                    
                    <div class="airwave-ticker-separator">•</div>
                    
                    <div class="airwave-song-history-ticker">
                        <div class="airwave-ticker-track">
                            <span class="airwave-history-item">Loading song history...</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <audio class="airwave-audio-player" preload="none"></audio>
        </div>
        <?php
        return ob_get_clean();
    }

    public function front_row_shortcode($atts) {
        $atts = shortcode_atts(array(
            'class' => ''
        ), $atts);
        
        $settings = get_option('airwave_settings', array());
        $raw = $settings['custom_front_row'] ?? '';
        $theme = $settings['display_theme'] ?? 'dark';
        if ($theme === 'system') { $theme = 'dark'; }
        $theme_class = 'awmx-theme-' . ($theme === 'neutral' ? 'neutral' : ($theme === 'light' ? 'light' : 'dark'));
        
        ob_start();
        ?>
        <div class="airwave-front-row canvas <?php echo esc_attr($theme_class); ?> <?php echo esc_attr($atts['class']); ?>">
            <div class="airwave-front-col">
                <?php echo do_shortcode($raw); ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    public function now_playing_shortcode($atts) {
        $atts = shortcode_atts(array(
            'stream' => '0',
            'show_cover' => 'true',
            'title' => '',
            'show_listeners' => 'true',
            'show_dj' => 'true'
        ), $atts);
        
        $stream_index = intval($atts['stream']);
        $show_cover = $atts['show_cover'] === 'true';
        $title = sanitize_text_field($atts['title']);
        $show_listeners = $atts['show_listeners'] === 'true';
        $show_dj = $atts['show_dj'] === 'true';
        
        ob_start();
        ?>
        <?php $settings = get_option('airwave_settings', array()); $theme = $settings['display_theme'] ?? 'dark'; if ($theme === 'system') { $theme = 'dark'; } $theme_class = 'awmx-theme-' . ($theme === 'neutral' ? 'neutral' : ($theme === 'light' ? 'light' : 'dark')); ?>
        <div class="airwave-now-playing-shortcode awmx-card <?php echo esc_attr($theme_class); ?>" data-stream="<?php echo esc_attr($stream_index); ?>" data-show-cover="<?php echo $show_cover ? 'true' : 'false'; ?>" data-show-listeners="<?php echo $show_listeners ? 'true' : 'false'; ?>" data-show-dj="<?php echo $show_dj ? 'true' : 'false'; ?>">
            <?php if ($title): ?>
                <h3 class="airwave-shortcode-title"><?php echo esc_html($title); ?></h3>
            <?php endif; ?>
            
            <div class="airwave-current-song">
                <h4>Now Playing</h4>
                <?php if ($show_cover): ?>
                <div class="airwave-song-art">
                    <img class="airwave-album-art" src="" alt="" style="display: none;" />
                </div>
                <?php endif; ?>
                <div class="airwave-song-info">
                    <div class="airwave-song-title">-</div>
                    <div class="airwave-song-artist">-</div>
                </div>
                <?php if ($show_listeners || $show_dj): ?>
                <div class="airwave-meta-info">
                    <?php if ($show_listeners): ?>
                    <div class="airwave-listeners-count">
                        <span class="airwave-meta-label">Listeners:</span>
                        <span class="airwave-listeners-value">-</span>
                    </div>
                    <?php endif; ?>
                    <?php if ($show_dj): ?>
                    <div class="airwave-dj-name">
                        <span class="airwave-meta-label">DJ:</span>
                        <span class="airwave-dj-value">-</span>
                    </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}
