<?php
// Developer helper: load local test credentials file if present
if (!defined('ABSPATH')) { exit; }

if (!defined('AIRWAVE_PLUGIN_PATH')) {
    // Attempt to define plugin path if not set
    define('AIRWAVE_PLUGIN_PATH', plugin_dir_path(__FILE__) . '../');
}

function airwave_test_credentials_file() {
    $candidates = array(
        AIRWAVE_PLUGIN_PATH . 'TEST-CREDENTIALS-LOCAL.json',
        dirname(AIRWAVE_PLUGIN_PATH) . '/TEST-CREDENTIALS-LOCAL.json'
    );
    foreach ($candidates as $path) {
        if (is_readable($path)) {
            return $path;
        }
    }
    return null;
}

function airwave_has_local_test_credentials() {
    return (bool) airwave_test_credentials_file();
}

function airwave_load_local_test_credentials() {
    $path = airwave_test_credentials_file();
    if (!$path) { return null; }
    $json = @file_get_contents($path);
    if ($json === false) { return null; }
    $data = json_decode($json, true);
    return is_array($data) ? $data : null;
}